 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 10/12/2012
 *
 ***********************************************/

 #ifndef __processor0_H
 #define __processor0_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String

 class processor0 : public Atomic
 {
   public:
	       processor0 ( const std::string &name = "processor0" );  //Default constructor
	       virtual std::string className() const {  return "processor0" ;}
	       ~processor0();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In;
	        Port &Out,&Req;
	        Time ProcessTime;
	        Time GenerateTime;
	        int Temp;
	        int OutPort;
	        int Mode; // 0 means Normal and 1 means CoMP
	        int RandCounter;
	        int ServingBS;
	        int i;
	        int Digit [6];
	        int SentPacketNum;
	        int ReceivedPacketNum;
         	enum State{
			            Idle,
			            RecPack,
			            RecACK,
			            SendPack,
			            AskNewTask,
			            UEMode,
		              };
		    State state;
 };

#endif   //__processor0_H
